/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;

public record EnchantmentRequirement(Either<TagKey<Enchantment>, Enchantment> enchantment, Optional<IntegerBounds> level) {
    public static final Codec<EnchantmentRequirement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ConfigHelper.tagOrForgeRegistryCodec(Registry.f_122902_, ForgeRegistries.ENCHANTMENTS).fieldOf("enchantment").forGetter(requirement -> requirement.enchantment), (App)IntegerBounds.CODEC.optionalFieldOf("levels").forGetter(requirement -> requirement.level)).apply((Applicative)instance, EnchantmentRequirement::new));

    public boolean test(Enchantment enchantment, int level) {
        return (Boolean)this.enchantment.map(tag -> ForgeRegistries.ENCHANTMENTS.tags().getTag(tag).contains((Object)enchantment), ench -> ench == enchantment) != false && this.level.map(bounds -> bounds.test(level)).orElse(true) != false;
    }

    public boolean test(Map<Enchantment, Integer> enchantments) {
        for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
            if (!this.test(entry.getKey(), entry.getValue())) continue;
            return true;
        }
        return false;
    }

    public CompoundTag serialize() {
        return (CompoundTag)CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this).result().orElseGet(CompoundTag::new);
    }

    public static EnchantmentRequirement deserialize(CompoundTag tag) {
        return (EnchantmentRequirement)((Pair)CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)tag).result().orElseThrow(() -> new IllegalArgumentException("Could not deserialize EnchantmentRequirement"))).getFirst();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EnchantmentRequirement that = (EnchantmentRequirement)obj;
        if (!this.enchantment.equals(that.enchantment)) {
            return false;
        }
        return this.level.equals(that.level);
    }

    @Override
    public String toString() {
        return CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("serialize_failed");
    }
}

